/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.immediate;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.util.ColorU8;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ColorVertex;
import net.minecraft.class_1011;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_4063;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_6854;
import net.minecraft.class_758;
import net.minecraft.class_9801;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryStack;

public class CloudRenderer {
    private static final class_2960 CLOUDS_TEXTURE_ID = class_2960.method_60656((String)"textures/environment/clouds.png");
    private CloudTextureData textureData;
    private class_5944 shaderProgram;
    @Nullable
    private CloudGeometry cachedGeometry;
    private static final Vector3f[][] VERTICES = new Vector3f[CloudFace.COUNT][];

    public CloudRenderer(class_5912 resourceProvider) {
        this.reloadTextures(resourceProvider);
    }

    public void render(class_4184 camera, class_638 level, Matrix4f projectionMatrix, class_4587 poseStack, float ticks, float tickDelta) {
        class_291 vertexBuffer;
        float cloudHeight = level.method_28103().method_28108();
        if (Float.isNaN(cloudHeight)) {
            return;
        }
        if (this.textureData.isBlank) {
            return;
        }
        class_243 pos = camera.method_19326();
        double cloudTime = (ticks + tickDelta) * 0.03f;
        double cloudCenterX = pos.method_10216() + cloudTime;
        double cloudCenterZ = pos.method_10215() + 0.33;
        int cloudDistance = CloudRenderer.getCloudRenderDistance();
        int centerCellX = (int)Math.floor(cloudCenterX / 12.0);
        int centerCellZ = (int)Math.floor(cloudCenterZ / 12.0);
        class_4063 cloudType = class_310.method_1551().field_1690.method_1632();
        float relativeCloudY = cloudHeight - (float)pos.method_10214() + 0.33f;
        int orientation = cloudType == class_4063.field_18164 ? (int)Math.signum(-relativeCloudY) : 0;
        CloudGeometryParameters parameters = new CloudGeometryParameters(centerCellX, centerCellZ, cloudDistance, orientation, cloudType);
        CloudGeometry geometry = this.cachedGeometry;
        if (geometry == null || !Objects.equals(geometry.params(), parameters)) {
            this.cachedGeometry = geometry = CloudRenderer.rebuildGeometry(geometry, parameters, this.textureData);
        }
        if ((vertexBuffer = geometry.vertexBuffer()) == null) {
            return;
        }
        float translateX = (float)(cloudCenterX - (double)(centerCellX * 12));
        float translateZ = (float)(cloudCenterZ - (double)(centerCellZ * 12));
        poseStack.method_22903();
        class_4587.class_4665 poseEntry = poseStack.method_23760();
        Matrix4f modelViewMatrix = poseEntry.method_23761();
        modelViewMatrix.translate(-translateX, relativeCloudY, -translateZ);
        class_6854 prevShaderFogShape = RenderSystem.getShaderFogShape();
        float prevShaderFogEnd = RenderSystem.getShaderFogEnd();
        float prevShaderFogStart = RenderSystem.getShaderFogStart();
        class_758.method_3211((class_4184)camera, (class_758.class_4596)class_758.class_4596.field_20946, (float)(cloudDistance * 8), (boolean)CloudRenderer.shouldUseWorldFog(level, pos), (float)tickDelta);
        boolean fastClouds = geometry.params().renderMode() == class_4063.field_18163;
        boolean fabulous = class_310.method_29611();
        if (fastClouds) {
            RenderSystem.disableCull();
        }
        if (fabulous) {
            class_310.method_1551().field_1769.method_29364().method_1235(false);
        }
        class_243 colorModulator = level.method_23785(tickDelta);
        RenderSystem.setShaderColor((float)((float)colorModulator.field_1352), (float)((float)colorModulator.field_1351), (float)((float)colorModulator.field_1350), (float)0.8f);
        vertexBuffer.method_1353();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.depthFunc((int)513);
        vertexBuffer.method_34427(modelViewMatrix, projectionMatrix, this.shaderProgram);
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableBlend();
        class_291.method_1354();
        if (fastClouds) {
            RenderSystem.enableCull();
        }
        if (fabulous) {
            class_310.method_1551().method_1522().method_1235(false);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderFogShape((class_6854)prevShaderFogShape);
        RenderSystem.setShaderFogEnd((float)prevShaderFogEnd);
        RenderSystem.setShaderFogStart((float)prevShaderFogStart);
        poseStack.method_22909();
    }

    @NotNull
    private static CloudGeometry rebuildGeometry(@Nullable CloudGeometry existingGeometry, CloudGeometryParameters parameters, CloudTextureData textureData) {
        int layer;
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        VertexBufferWriter writer = VertexBufferWriter.of((class_4588)bufferBuilder);
        int originCellX = parameters.originX();
        int originCellZ = parameters.originZ();
        int orientation = parameters.orientation();
        int radius = parameters.radius();
        boolean useFastGraphics = parameters.renderMode() == class_4063.field_18163;
        CloudRenderer.addCellGeometryToBuffer(writer, textureData, originCellX, originCellZ, 0, 0, orientation, useFastGraphics);
        for (layer = 1; layer <= radius; ++layer) {
            int x;
            int z;
            for (z = -layer; z < layer; ++z) {
                x = Math.abs(z) - layer;
                CloudRenderer.addCellGeometryToBuffer(writer, textureData, originCellX, originCellZ, x, z, orientation, useFastGraphics);
            }
            for (z = layer; z > -layer; --z) {
                x = layer - Math.abs(z);
                CloudRenderer.addCellGeometryToBuffer(writer, textureData, originCellX, originCellZ, x, z, orientation, useFastGraphics);
            }
        }
        for (layer = radius + 1; layer <= 2 * radius; ++layer) {
            int x;
            int z;
            int l = layer - radius;
            for (z = -radius; z <= -l; ++z) {
                x = -z - layer;
                CloudRenderer.addCellGeometryToBuffer(writer, textureData, originCellX, originCellZ, x, z, orientation, useFastGraphics);
            }
            for (z = l; z <= radius; ++z) {
                x = z - layer;
                CloudRenderer.addCellGeometryToBuffer(writer, textureData, originCellX, originCellZ, x, z, orientation, useFastGraphics);
            }
            for (z = radius; z >= l; --z) {
                x = layer - z;
                CloudRenderer.addCellGeometryToBuffer(writer, textureData, originCellX, originCellZ, x, z, orientation, useFastGraphics);
            }
            for (z = -l; z >= -radius; --z) {
                x = layer + z;
                CloudRenderer.addCellGeometryToBuffer(writer, textureData, originCellX, originCellZ, x, z, orientation, useFastGraphics);
            }
        }
        class_9801 builtBuffer = bufferBuilder.method_60794();
        class_291 vertexBuffer = null;
        if (builtBuffer != null) {
            if (existingGeometry != null) {
                vertexBuffer = existingGeometry.vertexBuffer();
            }
            if (vertexBuffer == null) {
                vertexBuffer = new class_291(class_291.class_8555.field_44794);
            }
            CloudRenderer.uploadToVertexBuffer(vertexBuffer, builtBuffer);
        }
        class_289.method_1348().method_60828();
        return new CloudGeometry(vertexBuffer, parameters);
    }

    private static void addCellGeometryToBuffer(VertexBufferWriter writer, CloudTextureData textureData, int originX, int originZ, int offsetX, int offsetZ, int orientation, boolean useFastGraphics) {
        int cellX = originX + offsetX;
        int cellZ = originZ + offsetZ;
        int cellIndex = textureData.getCellIndexWrapping(cellX, cellZ);
        int cellFaces = textureData.getCellFaces(cellIndex) & CloudRenderer.getVisibleFaces(offsetX, offsetZ, orientation);
        if (cellFaces == 0) {
            return;
        }
        int cellColor = textureData.getCellColor(cellIndex);
        if (ColorABGR.unpackAlpha(cellColor) == 0) {
            return;
        }
        float x = offsetX * 12;
        float z = offsetZ * 12;
        if (useFastGraphics) {
            CloudRenderer.emitCellGeometry2D(writer, cellFaces, cellColor, x, z);
        } else {
            CloudRenderer.emitCellGeometry3D(writer, cellFaces, cellColor, x, z, false);
            int distance = Math.abs(offsetX) + Math.abs(offsetZ);
            if (distance <= 1) {
                CloudRenderer.emitCellGeometry3D(writer, CloudFaceSet.all(), cellColor, x, z, true);
            }
        }
    }

    private static int getVisibleFaces(int x, int z, int orientation) {
        int faces = CloudFaceSet.all();
        if (x > 0) {
            faces = CloudFaceSet.remove(faces, CloudFace.POS_X);
        }
        if (z > 0) {
            faces = CloudFaceSet.remove(faces, CloudFace.POS_Z);
        }
        if (x < 0) {
            faces = CloudFaceSet.remove(faces, CloudFace.NEG_X);
        }
        if (z < 0) {
            faces = CloudFaceSet.remove(faces, CloudFace.NEG_Z);
        }
        if (orientation < 0) {
            faces = CloudFaceSet.remove(faces, CloudFace.POS_Y);
        }
        if (orientation > 0) {
            faces = CloudFaceSet.remove(faces, CloudFace.NEG_Y);
        }
        return faces;
    }

    private static void emitCellGeometry2D(VertexBufferWriter writer, int faces, int color, float x, float z) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(64);
            int count = 0;
            int mixedColor = ColorABGR.mulRGB(color, CloudFace.POS_Y.getShade());
            ptr = CloudRenderer.writeVertex(ptr, x + 12.0f, 0.0f, z + 12.0f, mixedColor);
            ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 0.0f, z + 12.0f, mixedColor);
            ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 0.0f, z + 0.0f, mixedColor);
            ptr = CloudRenderer.writeVertex(ptr, x + 12.0f, 0.0f, z + 0.0f, mixedColor);
            writer.push(stack, buffer, count += 4, ColorVertex.FORMAT);
        }
    }

    private static void emitCellGeometry3D(VertexBufferWriter writer, int visibleFaces, int baseColor, float posX, float posZ, boolean interior) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(384);
            int count = 0;
            for (CloudFace face : CloudFace.VALUES) {
                if (!CloudFaceSet.contains(visibleFaces, face)) continue;
                Vector3f[] vertices = VERTICES[face.ordinal()];
                int color = ColorABGR.mulRGB(baseColor, face.getShade());
                for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
                    Vector3f vertex = vertices[interior ? 3 - vertexIndex : vertexIndex];
                    float x = vertex.x + posX;
                    float y = vertex.y;
                    float z = vertex.z + posZ;
                    ptr = CloudRenderer.writeVertex(ptr, x, y, z, color);
                }
                count += 4;
            }
            if (count > 0) {
                writer.push(stack, buffer, count, ColorVertex.FORMAT);
            }
        }
    }

    private static long writeVertex(long buffer, float x, float y, float z, int color) {
        ColorVertex.put(buffer, x, y, z, color);
        return buffer + 16L;
    }

    private static void uploadToVertexBuffer(class_291 vertexBuffer, class_9801 builtBuffer) {
        vertexBuffer.method_1353();
        vertexBuffer.method_1352(builtBuffer);
        class_291.method_1354();
    }

    public void reloadTextures(class_5912 resourceProvider) {
        this.destroy();
        this.textureData = CloudRenderer.loadTextureData();
        try {
            this.shaderProgram = new class_5944(resourceProvider, "clouds", class_290.field_1576);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
        if (this.shaderProgram != null) {
            this.shaderProgram.close();
            this.shaderProgram = null;
        }
        if (this.cachedGeometry != null) {
            class_291 vertexBuffer = this.cachedGeometry.vertexBuffer();
            vertexBuffer.close();
            this.cachedGeometry = null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static CloudTextureData loadTextureData() {
        class_3300 resourceManager = class_310.method_1551().method_1478();
        class_3298 resource = (class_3298)resourceManager.method_14486(CLOUDS_TEXTURE_ID).orElseThrow();
        try (InputStream inputStream = resource.method_14482();){
            CloudTextureData cloudTextureData;
            block14: {
                class_1011 nativeImage = class_1011.method_4309((InputStream)inputStream);
                try {
                    cloudTextureData = new CloudTextureData(nativeImage);
                    if (nativeImage == null) break block14;
                }
                catch (Throwable throwable) {
                    if (nativeImage != null) {
                        try {
                            nativeImage.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                nativeImage.close();
            }
            return cloudTextureData;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to load texture data", ex);
        }
    }

    private static boolean shouldUseWorldFog(class_638 level, class_243 pos) {
        return level.method_28103().method_28110(class_3532.method_15357((double)pos.method_10216()), class_3532.method_15357((double)pos.method_10215())) || class_310.method_1551().field_1705.method_1740().method_1800();
    }

    private static int getCloudRenderDistance() {
        return Math.max(32, class_310.method_1551().field_1690.method_38521() * 2 + 9);
    }

    private static boolean isTransparentCell(int color) {
        return ColorARGB.unpackAlpha(color) <= 1;
    }

    static {
        CloudRenderer.VERTICES[CloudFace.NEG_Y.ordinal()] = new Vector3f[]{new Vector3f(12.0f, 0.0f, 12.0f), new Vector3f(0.0f, 0.0f, 12.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(12.0f, 0.0f, 0.0f)};
        CloudRenderer.VERTICES[CloudFace.POS_Y.ordinal()] = new Vector3f[]{new Vector3f(0.0f, 4.0f, 12.0f), new Vector3f(12.0f, 4.0f, 12.0f), new Vector3f(12.0f, 4.0f, 0.0f), new Vector3f(0.0f, 4.0f, 0.0f)};
        CloudRenderer.VERTICES[CloudFace.NEG_X.ordinal()] = new Vector3f[]{new Vector3f(0.0f, 0.0f, 12.0f), new Vector3f(0.0f, 4.0f, 12.0f), new Vector3f(0.0f, 4.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f)};
        CloudRenderer.VERTICES[CloudFace.POS_X.ordinal()] = new Vector3f[]{new Vector3f(12.0f, 4.0f, 12.0f), new Vector3f(12.0f, 0.0f, 12.0f), new Vector3f(12.0f, 0.0f, 0.0f), new Vector3f(12.0f, 4.0f, 0.0f)};
        CloudRenderer.VERTICES[CloudFace.NEG_Z.ordinal()] = new Vector3f[]{new Vector3f(12.0f, 4.0f, 0.0f), new Vector3f(12.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 4.0f, 0.0f)};
        CloudRenderer.VERTICES[CloudFace.POS_Z.ordinal()] = new Vector3f[]{new Vector3f(12.0f, 0.0f, 12.0f), new Vector3f(12.0f, 4.0f, 12.0f), new Vector3f(0.0f, 4.0f, 12.0f), new Vector3f(0.0f, 0.0f, 12.0f)};
    }

    private static class CloudTextureData {
        private final byte[] faces;
        private final int[] colors;
        private boolean isBlank;
        private final int width;
        private final int height;

        public CloudTextureData(class_1011 texture) {
            int width = texture.method_4307();
            int height = texture.method_4323();
            this.faces = new byte[width * height];
            this.colors = new int[width * height];
            this.isBlank = true;
            this.width = width;
            this.height = height;
            this.loadTextureData(texture, width, height);
        }

        private void loadTextureData(class_1011 texture, int width, int height) {
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < height; ++z) {
                    int color;
                    int index = this.getCellIndex(x, z);
                    this.colors[index] = color = texture.method_4315(x, z);
                    if (CloudRenderer.isTransparentCell(color)) continue;
                    this.faces[index] = (byte)CloudTextureData.getOpenFaces(texture, color, x, z);
                    this.isBlank = false;
                }
            }
        }

        private static int getOpenFaces(class_1011 image, int color, int x, int z) {
            int faces = CloudFaceSet.empty();
            faces = CloudFaceSet.add(faces, CloudFace.NEG_Y);
            faces = CloudFaceSet.add(faces, CloudFace.POS_Y);
            int neighbor = CloudTextureData.getNeighborTexel(image, x - 1, z);
            if (color != neighbor) {
                faces = CloudFaceSet.add(faces, CloudFace.NEG_X);
            }
            if (color != (neighbor = CloudTextureData.getNeighborTexel(image, x + 1, z))) {
                faces = CloudFaceSet.add(faces, CloudFace.POS_X);
            }
            if (color != (neighbor = CloudTextureData.getNeighborTexel(image, x, z - 1))) {
                faces = CloudFaceSet.add(faces, CloudFace.NEG_Z);
            }
            if (color != (neighbor = CloudTextureData.getNeighborTexel(image, x, z + 1))) {
                faces = CloudFaceSet.add(faces, CloudFace.POS_Z);
            }
            return faces;
        }

        private static int getNeighborTexel(class_1011 image, int x, int z) {
            x = CloudTextureData.wrapTexelCoord(x, 0, image.method_4307() - 1);
            z = CloudTextureData.wrapTexelCoord(z, 0, image.method_4323() - 1);
            return image.method_4315(x, z);
        }

        private static int wrapTexelCoord(int coord, int min, int max) {
            if (coord < min) {
                coord = max;
            }
            if (coord > max) {
                coord = min;
            }
            return coord;
        }

        public int getCellFaces(int index) {
            return this.faces[index];
        }

        public int getCellColor(int index) {
            return this.colors[index];
        }

        private int getCellIndexWrapping(int x, int z) {
            return this.getCellIndex(Math.floorMod(x, this.width), Math.floorMod(z, this.height));
        }

        private int getCellIndex(int x, int z) {
            return x * this.width + z;
        }
    }

    public record CloudGeometryParameters(int originX, int originZ, int radius, int orientation, class_4063 renderMode) {
    }

    public record CloudGeometry(class_291 vertexBuffer, CloudGeometryParameters params) {
    }

    private static class CloudFaceSet {
        private CloudFaceSet() {
        }

        public static int empty() {
            return 0;
        }

        public static boolean contains(int set, CloudFace face) {
            return (set & 1 << face.ordinal()) != 0;
        }

        public static int add(int set, CloudFace face) {
            return set | 1 << face.ordinal();
        }

        public static int remove(int set, CloudFace face) {
            return set & ~(1 << face.ordinal());
        }

        public static int all() {
            return (1 << CloudFace.COUNT) - 1;
        }
    }

    private static enum CloudFace {
        NEG_Y(0.7f),
        POS_Y(1.0f),
        NEG_X(0.9f),
        POS_X(0.9f),
        NEG_Z(0.8f),
        POS_Z(0.8f);

        public static final CloudFace[] VALUES;
        public static final int COUNT;
        private final int shade;

        private CloudFace(float shade) {
            this.shade = ColorU8.normalizedFloatToByte(shade);
        }

        public int getShade() {
            return this.shade;
        }

        static {
            VALUES = CloudFace.values();
            COUNT = VALUES.length;
        }
    }
}

